; Search procedure with hash ebx in module ebp
; Code by peci (intel syntax translation by ryg)

GetProcAddress:
	push		esi
	push		edi

	mov		eax, [ebp + 03ch]		; eax = PE header offset
	mov		edx, [ebp + eax + 078h]		; edx = exports directory table offset
	add		edx, ebp			; edx = exports directory table address
	push		edx
	mov		edx, [edx + 020h]		; edx = name pointers table offset
	add		edx, ebp			; edx = name pointers table address

	; Check all names of procedure for the right hash
	xor		eax, eax
	xor		ecx, ecx
	
ScanProcedureNamesLoop:
	inc		ecx
	mov		esi, [edx + ecx*4]		; esi = name pointer offset
	add		esi, ebp			; esi = name pointer address
	xor		edi, edi
	
CalculateHashLoop:
	ror		edi, 013h
	lodsb
	add		edi, eax
	test		eax, eax
	jnz		CalculateHashLoop

	cmp		edi, ebx			; check computed hash
	jnz		ScanProcedureNamesLoop

	; Found, get the address from the table
	pop		edx
	mov		ebx, [edx + 024h]		; ebx = ordinals table RNA offset
	add		ebx, ebp			; ebx = ordinals table RNA address
	mov		cx, [ebx + ecx*2]		; ecx = function ordinal
	mov		ebx, [edx + 01ch]		; ebx = address table RVA offset
	add		ebx, ebp			; ebx = address table RVA address
	mov		eax, [ebx + ecx*4]		; eax = address of function RVA offset
	add		eax, ebp

	pop		edi
	pop		esi
	ret
