# // Search Procedure with hash %ebx in module %ebp, then jmp to it.
# // Code by peci

GetProcAddress:
	pushl		%esi
	pushl		%edi
	movl		0x3c(%ebp), %eax		#// eax = PE header offset
	movl		0x78(%ebp,%eax), %edx		#// edx = exports directory table offset
	addl		%ebp, %edx			#// edx = exports directory table address
	pushl		%edx
	movl		0x20(%edx), %edx		#// edx = name pointers table offset
	addl		%ebp, %edx			#// edx = name pointers table address
	
	#// Check all names of procedures for the right hash
	xorl		%eax, %eax
	xorl		%ecx, %ecx

ScanProcedureNamesLoop:
	incl		%ecx
	movl		(%edx, %ecx, 4), %esi		#// esi = name pointer offset
	add		%ebp, %esi			#// esi = name pointer address
	xorl		%edi, %edi

CalculateHashLoop:
	rorl		$0x13, %edi
	lodsb
	addl		%eax, %edi
	testl		%eax, %eax
	jnz		CalculateHashLoop
	
	cmpl		%ebx, %edi			#// check computed hash
	jnz		ScanProcedureNamesLoop

	#// Found, get the address from the table
	popl		%edx
	movl		0x24(%edx), %ebx		#// ebx = ordinals table RNA offset
	addl		%ebp, %ebx			#// ebx = ordinals table RNA address
	movw		(%ebx, %ecx, 2), %cx		#// ecx = function ordinal
	movl		0x1c(%edx), %ebx		#// ebx = address table RVA offset
	addl		%ebp, %ebx			#// ebx = address table RVA address
	movl		(%ebx, %ecx, 4), %eax		#// eax = address of function RVA offset
	addl		%ebp, %eax			#// eax = address of function RVA address

	popl		%edi
	popl		%esi
	ret
